#include "FunctionControls.h"

#ifdef __APPLE__
#include <GLUT/glut.h>
#include <OpenGL/gl.h>
#else
#include <GL/glut.h>
#include <GL/gl.h>
#endif

#include <math.h>
#include <stdlib.h>

#include "Matrix.h"
#include "NumberField.h"
#include "Quaternion.h"
#include "Vector.h"
#include "Utilities.h"

enum {
	MULTIPLY_X = 0,
	MULTIPLY_Y,
	MULTIPLY_Z,
	MULTIPLY_W,
	SLERP_X,
	SLERP_Y,
	SLERP_Z,
	SLERP_W,
	SLERP_ALPHA,
	ROTATE_X,
	ROTATE_Y,
	ROTATE_Z,
	ROTATE_ANGLE,
	NUMBER_OF_FIELDS
};

static NumberField numberFields[NUMBER_OF_FIELDS];
static int editNumberField = -1;

static void callback(void * context, float newValue) {
	glutPostRedisplay();
}

void FunctionControls_init() {
	numberFields[MULTIPLY_X] = NumberField_create(true, 0.0f, 0.005f, callback, NULL, 0, 406, 72);
	numberFields[MULTIPLY_Y] = NumberField_create(true, 0.0f, 0.005f, callback, NULL, 0, 481, 72);
	numberFields[MULTIPLY_Z] = NumberField_create(true, 0.0f, 0.005f, callback, NULL, 0, 556, 72);
	numberFields[MULTIPLY_W] = NumberField_create(true, 1.0f, 0.005f, callback, NULL, 0, 631, 72);
	
	numberFields[SLERP_X] = NumberField_create(true, 0.0f, 0.005f, callback, NULL, 0, 382, 51);
	numberFields[SLERP_Y] = NumberField_create(true, 0.0f, 0.005f, callback, NULL, 0, 457, 51);
	numberFields[SLERP_Z] = NumberField_create(true, 0.0f, 0.005f, callback, NULL, 0, 532, 51);
	numberFields[SLERP_W] = NumberField_create(true, 1.0f, 0.005f, callback, NULL, 0, 607, 51);
	numberFields[SLERP_ALPHA] = NumberField_create(true, 0.5f, 0.005f, callback, NULL, 0, 711, 51);
	
	numberFields[ROTATE_X] = NumberField_create(true, 0.0f, 0.005f, callback, NULL, 0, 353, 30);
	numberFields[ROTATE_Y] = NumberField_create(true, 1.0f, 0.005f, callback, NULL, 0, 428, 30);
	numberFields[ROTATE_Z] = NumberField_create(true, 0.0f, 0.005f, callback, NULL, 0, 503, 30);
	numberFields[ROTATE_ANGLE] = NumberField_create(true, M_PI / 5.0, 0.005f, callback, NULL, 0, 607, 30);
}

bool FunctionControls_mouseDown(int x, int y) {
	int numberFieldIndex;
	
	for (numberFieldIndex = 0; numberFieldIndex < NUMBER_OF_FIELDS; numberFieldIndex++) {
		if (NumberField_hitTest(&numberFields[numberFieldIndex], x, y)) {
			editNumberField = numberFieldIndex;
			return true;
		}
	}
	return false;
}

void FunctionControls_mouseUp(int x, int y) {
	editNumberField = -1;
}

void FunctionControls_mouseDragged(int x, int y) {
	if (editNumberField != -1) {
		NumberField_mouseDragged(&numberFields[editNumberField], x, y);
	}
}

void FunctionControls_draw() {
	int numberFieldIndex;
	
	for (numberFieldIndex = 0; numberFieldIndex < NUMBER_OF_FIELDS; numberFieldIndex++) {
		NumberField_draw(&numberFields[numberFieldIndex], numberFieldIndex == editNumberField);
	}
	
	drawGlutString(65, 117, "Quaternion_normalize()");
	
	drawGlutString(65, 96, "Quaternion_invert()");
	
	drawGlutString(65, 75, "Quaternion_multiply(Quaternion_withValues(");
	drawGlutString(711, 75, "));");
	
	drawGlutString(65, 54, "Quaternion_slerp(Quaternion_withValues(");
	drawGlutString(682, 54, "), ");
	drawGlutString(786, 54, ");");
	
	drawGlutString(65, 33, "Quaternion_rotate(Vector_withValues(");
	drawGlutString(578, 33, "), ");
	drawGlutString(682, 33, ");");
}

void FunctionControls_setEditFieldValue(float value) {
	if (editNumberField != -1) {
		NumberField_setValue(&numberFields[editNumberField], value);
	}
}

float FunctionControls_getEditFieldValue() {
	if (editNumberField != -1) {
		return numberFields[editNumberField].value;
	}
	return 0.0f;
}

void FunctionControls_setMultiplyQuaternion(Quaternion quaternion) {
	numberFields[MULTIPLY_X].value = quaternion.x;
	numberFields[MULTIPLY_Y].value = quaternion.y;
	numberFields[MULTIPLY_Z].value = quaternion.z;
	numberFields[MULTIPLY_W].value = quaternion.w;
}

Quaternion FunctionControls_multiply(Quaternion quaternion) {
	return Quaternion_multiplied(quaternion, Quaternion_withValues(numberFields[MULTIPLY_X].value, numberFields[MULTIPLY_Y].value, numberFields[MULTIPLY_Z].value, numberFields[MULTIPLY_W].value));
}

void FunctionControls_setSLERPQuaternion(Quaternion quaternion) {
	numberFields[SLERP_X].value = quaternion.x;
	numberFields[SLERP_Y].value = quaternion.y;
	numberFields[SLERP_Z].value = quaternion.z;
	numberFields[SLERP_W].value = quaternion.w;
}

Quaternion FunctionControls_slerp(Quaternion quaternion) {
	return Quaternion_slerp(quaternion, Quaternion_withValues(numberFields[SLERP_X].value, numberFields[SLERP_Y].value, numberFields[SLERP_Z].value, numberFields[SLERP_W].value), numberFields[SLERP_ALPHA].value);
}

void FunctionControls_setRotateAxisAngle(struct Vector axis, float angle) {
	numberFields[ROTATE_X].value = axis.x;
	numberFields[ROTATE_Y].value = axis.y;
	numberFields[ROTATE_Z].value = axis.z;
	numberFields[ROTATE_ANGLE].value = angle;
}

Quaternion FunctionControls_rotate(Quaternion quaternion) {
	return Quaternion_rotated(quaternion, Vector_withValues(numberFields[ROTATE_X].value, numberFields[ROTATE_Y].value, numberFields[ROTATE_Z].value), numberFields[ROTATE_ANGLE].value);
}
